import re
from typing import Optional


def extract_last_number(line: str) -> int:
    result = 0
    extract_last_number.pattern = re.compile(r'(\d+(\.?\d+)?)')
    try:
        matches = extract_last_number.pattern.findall(line)
        return int(matches[-1][0])
    except:  # noqa
        return result


def postprocess(
        judge_reqs: list[dict],  # noqa
        judge_resps: list[dict],  # noqa
        judge_models: list[dict],  # noqa
        data: dict,  # noqa
        resp: dict,  # noqa
        **kwargs,
) -> bool | int | str | float | None:
    key = 'score'
    judge_resps[0][key] = parse_score_from_content(judge_resps[0]['content'])
    return judge_resps[0][key]
