import re


default_cot_pairs = [('<think>', '</think>'), ('<Think>', '</Think>')]
def remove_cot(text: str, cot_pairs=None) -> str:
    if cot_pairs is None:
        cot_pairs = default_cot_pairs
    ret = text
    for t0, t1 in cot_pairs:
        ret = re.sub(f"{t0}.*?{t1}", '', ret, flags=re.DOTALL)
    return ret.strip()


def preprocess(data: dict , resp: dict, **kwargs) -> bool | int | str | float | None:
    field = 'clean'
    resp[field] = remove_cot(resp['content'])
    return resp[field]
